<?php
/* **********************************************************************
 *
 * Copyright (C) 2003 Alejandro Garcia Gonzalez.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the  Free Software Foundation;  either version 2 of the License,  or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,  but
 * WITHOUT  ANY  WARRANTY;    without  even  the  implied  warranty  of
 * MERCHANTABILITY  or  FITNESS FOR A PARTICULAR PURPOSE.   See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the  GNU  General  Public License
 * along  with  this  program;  if not,  write  to  the  Free  Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * **********************************************************************
 *
 *	Clase:			Nexus Template ('nxs_tpl.inc.php')
 *	Version:		1.2
 *	Autor:			Alejandro Garcia Gonzalez <nexus@nuestroweb.com>
 *	Web:				http://nexus.nuestroweb.com
 *
 * Descripcion:
 *
 * Esta clase esta desarrollada principalmente para su rapido uso e
 * implementacion, he separado todo en pequeñas funciones, dando la
 * posibilidad tanto de agregar nuevas funciones como: 'cargar()' o
 * agregar nuevas posibilidades.   Su uso puede ser desde detallado
 * hasta rapido y sin complicaciones.
 *
 * ********************************************************************** */

class nxs_tpl
{

	/*
	 * Variables Privadas
	 */
	var $base;
	var $archivo;
	var $contenido;
	var $variables = array();
	var $globals = array();
	var $show = array();
	var $var_ini = "{";
	var $var_fin = "}";
	var $par_ini = '<!--\{';
	var $par_fin = '\}-->';
	var $msg_error = "si"; 			// "si" | "no" | "halt"
	var $sin_valor = "borrar"; 	// "borrar" | "marcar" | "mantener"

	/**
	 * void tpl([string $base]);
	 * -------------------------
	 * Constructor.
	 * Asigna el directorio base de las plantillas.
	 */
	function nxs_tpl($base = "./"){
		global $global;
		global $show;
		$this->globals =& $global;
		$this->show =& $show;
		$this->base = $base;

		if(!defined('BR')){
			define('BR', "\r\n", TRUE);
		}
	}

	/**
	 * void asignar_base([string $base]);
	 * ----------------------------------
	 * Asigna el directorio base de las plantillas.
	 */
	function asignar_base($base = "./"){
		$this->base = $base;
	}

	/**
	 * void asignar_tags([string $inicio], [string $final]);
	 * -----------------------------------------------------
	 * Asigna los caracteres que encierran las variables en las Plantillas.
	 */
	function asignar_tags($inicio = "{", $final = "}"){
		$this->var_ini = $inicio;
		$this->var_fin = $final;
	}

	/**
	 * void asignar_partes([string $inicio], [string $final]);
	 * -------------------------------------------------------
	 * Asigna los caracteres que encierran las partes en las Plantillas.
	 */
	function asignar_partes($inicio = "<!--{", $final = "}-->"){
		$this->par_ini = $inicio;
		$this->par_fin = $final;
	}

	/**
	 * void asignar_error([string $msg_error]);
	 * ----------------------------------------
	 * Asigna el estado de manejo de errores con los siguientes valores:
	 * "no" - No reporta los errores encontrados
	 * "si" - Reporta los errores encontrados
	 * "halt" - Reporta el primer error y detiene la ejecucion
	 */
	function asignar_error($msg_error = ""){
		if ($msg_error == "si"){
			$this->msg_error = $msg_error;
		}
		elseif ($msg_error == "halt"){
			$this->msg_error = $msg_error;
		}
		else {
			$this->msg_error = "no";
		}
	}

	/**
	 * void asignar_sin_valor([string $sin_valor]);
	 * --------------------------------------------
	 * Asigna el estado de manejo de variables no definidas en la Plantilla
	 * con los siguintes valores:
	 * "borrar" - Borra todas la variables no definidas
	 * "marcar" - Resalta las Variables no definidas
	 * "mantener" - No hace nada con las Variables no definidas
	 */
	function asignar_sin_valor($sin_valor = ""){
		if ($sin_valor == "marcar"){
			$this->sin_valor = $sin_valor;
		}
		elseif ($sin_valor == "borrar"){
			$this->sin_valor = $sin_valor;
		}
		else {
			$this->sin_valor = "mantener";
		}
	}

	/**
	 * void nuevo();
	 * -------------
	 * Borra todas las variables definidas anteriormente.
	 */
	function nuevo(){
		$this->archivo = '';
		$this->contenido = '';
		foreach ($this->variables as $elemento){
  			unset($elemento);
		}
	}

	/**
	 * string abrir(string $archivo);
	 * ------------------------------
	 * Abre el archivo especificado en '$archivo'.
	 */
	function abrir($archivo){
		$this->archivo = $this->base . $archivo;
		if (file_exists($this->archivo)){
			if ($this->contenido = file_get_contents($this->archivo)){
			//if ($fp = fopen($this->archivo, 'r')){
				//$this->contenido = fread($fp, filesize($this->archivo));
				//fclose($fp);
				return $this->contenido;
			}
			$this->debug("Plantilla no legible ($this->archivo)");
			return false;
		}
		$this->debug("Plantilla Inexistente ($this->archivo)");
		return false;
	}

	/**
	 * string extraer_parte(string $parte);
	 * ------------------------------------
	 * Funcion encargada de extraer el texto econtrado entre los separadores
	 * de partes.
	 */
	function extraer_parte($parte){

		if (!empty($parte) && preg_match('/' . $this->par_ini . $parte . $this->par_fin . '(.*)' . $this->par_ini . '\/' . $parte . $this->par_fin . '/msU', $this->contenido, $resultado)){

			$this->contenido = $resultado[1];
			return $this->contenido;
		}
		$this->contenido = '';
		$this->debug("No se encontró parte ($parte)");
		return false;
	}

	/**
	 * string extraer_sin_parte(string $parte);
	 * ----------------------------------------
	 * Funcion encargada de extraer el texto econtrado entre los separadores
	 * de partes.
	 */
	function extraer_sin_parte($parte){
		if (!empty($parte) && preg_match('/(.*)' . $this->par_ini . $parte . $this->par_fin . '(.*)' . $this->par_ini . '\/' . $parte . $this->par_fin . '(.*)/', $this->contenido, $resultado)){
			$this->contenido = $resultado[1] . $resultado[3];
			return $this->contenido;
		}
		$this->contenido = '';
		$this->debug("No se encontró parte ($parte)");
		return false;
	}

	/**
	 * bool agregar_vars(mixed $nombre, [string $valor]);
	 * --------------------------------------------------
	 * Esta funcion agrega ya sea, un array al array de variables interna,
	 * o se puede pasar uno a uno los valores que se agregaran a el array
	 * de variables interna '$variables'.
	 */
	function agregar_vars($nombre, $valor = ""){
		if (is_array($nombre)){
			$this->variables = $nombre;
			return true;
		}
		elseif ($nombre != "" && $valor != ""){
			$this->variables[$nombre] = $valor;
			return true;
		}
		else {
			$this->debug("No se han podido asignar las variables");
			return false;
		}
	}

	/**
	 * string parser();
	 * ----------------
	 * Reemplaza y devuelve las variables de '$contenido'.
	 */
	function parser(){
		if ($this->auth()){


			//$vars = array_merge($this->globals, $this->variables);
			$vars = $this->variables;
				
			while (list($nombre, $valor) = each($vars)){
				if(preg_match('/\{'.$nombre.'\.+(money|date|int|decimal|text|trim(\w.+))\}/', $this->contenido, $format)){
					if (isset($format[2])){
						$extra = $format[2];
						$nombre = $nombre . "." . $format[1];
						$format[1] = str_replace($extra, "", $format[1]);
					}
					else {
						$nombre = $nombre . "." . $format[1];
					}
					$valor = $this->format($format[1], $valor, $extra);
				}
				$this->contenido = str_replace($this->var_ini.$nombre.$this->var_fin, $valor, $this->contenido);
			}

			if ($this->sin_valor == "borrar"){
				// Vieja regexp '(\w.+)'
				$this->contenido = preg_replace('/'.$this->par_ini.'([A-Za-z0-9_.-]+)'.$this->par_fin.'/', "", $this->contenido);	// Variables de inicio de Partes
				$this->contenido = preg_replace('/'.$this->par_ini.'\/([A-Za-z0-9_.-]+)'.$this->par_fin.'/', "", $this->contenido);	// Variables de final de Partes
				$this->contenido = preg_replace('/'.$this->par_ini.'\/\@'.$this->par_fin.'/', "", $this->contenido);				// Variables de Permisos
				$this->contenido = preg_replace('/'.$this->var_ini.'([A-Za-z0-9_.-]+)'.$this->var_fin.'/', "", $this->contenido);	// Variables Nomales Nuevo
			}
			elseif ($this->sin_valor == "marcar"){
				// Vieja regexp '(\w.+)'
				$this->contenido = preg_replace('/'.$this->par_ini.'([A-Za-z0-9_.-]+)'.$this->par_fin.'/', "<b>Principio de Parte:</b> \\1", $this->contenido);
				$this->contenido = preg_replace('/'.$this->par_ini.'\/([A-Za-z0-9_.-]+)'.$this->par_fin.'/', "<b>Final de Parte:</b> \\1", $this->contenido);
				$this->contenido = preg_replace('/'.$this->var_ini.'([A-Za-z0-9_.-]+)'.$this->var_fin.'/', "<b>Sin definir:</b> \\1", $this->contenido);
			}
			return $this->contenido;
		}
		$this->debug("No hay ninguna Platilla abierta");
		return false;
	}

	function auth()
	{
		//global $debug; //DELETE

		// Variables
		$adder = true;
		$content = "";
		$auth['level'] = $_SESSION['nivel'];
		$auth['show'] = array();
		if (!empty($this->show)) {
			foreach ($this->show as $nombre => $valor){
				if ($valor == true){
					$auth['show'][$nombre] = true;
				}
			}
		}

		// Expresiones regulares
		$regexp1 = '/(.*)' . $this->par_ini.'\@\((.*)\)'. $this->par_fin . '(.*)/';
		$regexp2 = '/(.*)' . $this->par_ini . '\/\@' . $this->par_fin.'(.*)/';

		// Verificacion de Permisos
		$permitidos = array_merge(array_keys($auth['show']), array($_SESSION['nivel']));

		//if ($debug) p($permitidos); // DELETE

		// Se limpia el template y se reasignan los saltos de linea
		$this->contenido = preg_replace("(\r\n|\r|\n)", BR, $this->contenido);
		$lineas = explode(BR, $this->contenido);
		foreach ($lineas as $linea_num => $linea){

			// Si se encuentra
			if ($adder == true && preg_match($regexp1, $linea, $open)){
				$adder = false;
				$block['level'] = array();
				$block['show'] = array();
				$has_show = false;

				// Se verifican los permisos
				$permisos = explode(",", $open[2]);
				foreach($permisos as $permiso){
					if (is_numeric($permiso)){
						$block['level'][] = $permiso;
					}
					else {
						$block['show'][$permiso] = true;
						//if ($debug) { p($permiso);  p($auth['show']); } // DELETE
						if (in_array($permiso, array_keys($auth['show']))){
							$has_show = true;
						}
					}
				}
				//if ($debug) p($block); // DELETE

				// Se revisa niveles de acceso
				$has_level = count($block['level']) > 0 ? true : false;
				$has_perms = $has_level && in_array($auth['level'], $block['level']) ? true : false;
				$has_string = count($block['show']) > 0 ? true : false;
				//if ($debug) echo "Level: " . $has_level . "<br>" . "Perms: " . $has_perms . "<br>" . "String: " . $has_string . "<br>" . "Show: " . $has_show . "<br>"; // DELETE

				if ( ($has_level && $has_perms && $has_string && $has_show) || ($has_level && $has_perms && !$has_string) || (!$has_level && $has_string && $has_show) ){
					$adder = true;
				}

				if (!$adder && ereg($regexp2, $open[3], $sameline)){
					$content .= $open[1] . $sameline[2] . BR;
					$adder = true;
				}
				elseif($adder && ereg($regexp2, $open[3], $sameline)) {
					$content .= $open[1] . $sameline[1] . $sameline[2] . BR;
				}
				else {
					$content . $open[1] . BR;
				}
			}


			elseif (!$adder && ereg($regexp2, $linea, $close)){
				$adder = true;
				$content .= $close[2] . BR;
			}
			else {
				if ($adder){
					$content .= $linea . BR;
				}
			}
		}

		$this->contenido = $content;
		return true;
	}

	function format ($type, $value, $extra = false){
		$output = $value;
		if ($type == "money"){
			if (is_numeric($value)){ $output = number_format($value, 2, '.', ','); }
		}
		elseif ($type == "date"){
			if(ereg("([0-9]{4})-([0-9]{1,2})-([0-9]{1,2})", $value, $registro)){
				$day = $registro[3]; $month = $registro[2]; $year = $registro[1];
				$output = sprintf("%02d-%02d-%04d", $day, $month, $year);
			}
		}
		elseif ($type == "int"){
			if (is_numeric($value)){ $output = number_format($value, 0, '', ','); }
		}
		elseif ($type == "decimal"){
			if (is_numeric($value)){ $output = number_format($value, 4, '.', ','); }
		}
		elseif ($type == "text"){
			if (!empty($value)){ $output = nl2br($value); }
		}
		elseif ($type == "trim" && $extra){
			if (!empty($value)){ $output = cut_text($value, $extra); }
		}
		return $output;
	}

	/**
	 * string cargar(string $archivo, [array $vars]);
	 * ----------------------------------------------
	 * Funcion que devuelve el contenido completo de la plantilla '$archivo'
	 * con sus variables reemplazadas de '$vars'
	 */
	function cargar($archivo, $vars = false){
		$this->nuevo();
		$this->abrir($archivo);
		(!empty($vars)) ? $this->agregar_vars($vars): '';
		$this->parser();
		return $this->contenido;
	}

	/**
	 * string cargar_parte(string $archivo, string $parte, [array $vars]);
	 * -------------------------------------------------------------------
	 * Funcion que devuelve el contenido de la plantilla '$archivo' encerrado
	 * entre separadores de parte de nombre '$parte' y con sus variables
	 * reemplazadas de '$vars'
	 */
	function cargar_parte($archivo, $parte, $vars=""){
		$this->nuevo();
		$this->abrir($archivo);
		$this->extraer_parte($parte);
		(!empty($vars)) ? $this->agregar_vars($vars): '';
		$this->parser();
		return $this->contenido;
	}

	/*
	 * string cargar_sin_parte(string $archivo, string $parte, [array $vars]);
	 * -----------------------------------------------------------------------
	 * Funcion que devuelve el contenido de la plantilla '$archivo' sin incluir
	 * el contenido que se encuentra entre los separadores de parte de nombre
	 * '$parte' y con sus variables reemplazadas de '$vars'
	 */
	function cargar_sin_parte($archivo, $parte, $vars=""){
		$this->nuevo();
		$this->abrir($archivo);
		$this->extraer_sin_parte($parte);
		(!empty($vars)) ? $this->agregar_vars($vars): '';
		$this->parser();
		return $this->contenido;
	}

	/*
	 * string cagar_js($js);
	 * -----------------------------------------------------------------------
	 * Funcion para cargar archivos externos de javascript, de la forma:
	 * <script language='javascript' src='archivo.js'></script>
	 * donde '$js' es el archivo llamado.
	 */
	function cargar_js($js){
		$js = "js/" . $js;
	 	if (file_exists($js)){
	 		$script = "<script type=\"text/javascript\" language=\"JavaScript\" src=\"$js\"></script>\n";
			return $script;
	 	}
		$this->debug("Archivo JavaScript ($js) no Encontrado.");
		return false;
	 }

	/*
	 * void debug(string $msg);
	 * ------------------------
	 * Funcion para el manejo de errores de la clase.
	 */
	function debug($msg){
		if ($this->msg_error == "si"){
			echo "<br><b>Error:</b> " . $msg . "<br>";
		}
		elseif ($this->msg_error == "halt"){
			die ("<br><b>Error:</b> " . $msg . "<br>");
		}
		return false;
	}
}

?>